<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Safe extends Model 
{

    protected $table = 'safes';
    public $timestamps = true;
    protected $fillable = array('current_balance', 'currency', 'name');

    public function clientPayments()
    {
        return $this->hasMany('App\Models\ClientPayment');
    }

    public function transactions()
    {
        return $this->hasMany('App\Models\Transaction');
    }

}